#!/usr/bin/env bash

update_system() {
    if [ ! -f "/var/log/pitc_upgrade_done" ]; then
        log "\n📦 Updating system packages..."
        sudo apt update && sudo apt full-upgrade -y
        sudo apt autoremove -y && sudo apt clean
        log "\n🕒 Setting system timezone to Europe/London..."
        sudo timedatectl set-timezone Europe/London
        touch /var/log/pitc_upgrade_done
    else
        log "🔄 System already updated."
    fi
}

configure_cpu_isolation() {
    local cmdline_file="/boot/cmdline.txt"
    if ! grep -q "isolcpus=2" "$cmdline_file"; then
        log "\n🧬 Adding isolcpus=2 to cmdline.txt..."
        sudo sed -i 's/$/ isolcpus=2/' "$cmdline_file"
    else
        log "🔄 isolcpus=2 already present."
    fi
}
