#!/usr/bin/env bash

deploy_scripts() {
    log "\n📂  Downloading and extracting scripts.zip..."
    curl -L https://www.planesintheclouds.com/pitc-core/core-deployment/scripts.zip -o "$ADMIN_HOME/scripts.zip"
    unzip -o "$ADMIN_HOME/scripts.zip" -d "$ADMIN_HOME/"

    [ -d "$ADMIN_HOME/Scripts" ] && mv "$ADMIN_HOME/Scripts" "$ADMIN_HOME/scripts"
    mv "$ADMIN_HOME/scripts/"*.py "$ADMIN_HOME/"
    chmod 777 "$ADMIN_HOME"/*.py
}

setup_systemd_service() {
    if [ -f "$ADMIN_HOME/scripts/startup.service" ]; then
        log "\n⚙️  Installing startup.service to systemd..."
        sudo cp "$ADMIN_HOME/scripts/startup.service" /etc/systemd/system/startup.service
        sudo systemctl daemon-reload
        sudo systemctl enable startup.service
        sudo systemctl start startup.service
        sudo systemctl status startup.service --no-pager
    fi
    rm -rf "$ADMIN_HOME/scripts" "$ADMIN_HOME/scripts.zip"
}
