#!/usr/bin/env bash

ADMIN_HOME="/home/admin"

install_rgb_matrix() {
    if [ ! -d "$ADMIN_HOME/rpi-rgb-led-matrix" ]; then
        cd "$ADMIN_HOME"
        if [ ! -f "rgb-matrix.sh" ]; then
            log "\n⬇️  Downloading rgb-matrix.sh..."
            curl -s -O https://raw.githubusercontent.com/chrismorgans/Raspberry-Pi-Installer-Scripts/main/rgb-matrix.sh
            chmod +x rgb-matrix.sh
        fi
        log "📦 Installing RGB Matrix..."
        (echo "Y"; sleep 2; echo "2"; sleep 2; echo "N"; sleep 2; echo "2"; sleep 2; echo "Y"; sleep 2; echo "N") | sudo bash rgb-matrix.sh
    else
        log "🔄 RGB Matrix already installed."
    fi
}

run_demo() {
    if [ -d "$ADMIN_HOME/rpi-rgb-led-matrix/examples-api-use/" ]; then
        cd "$ADMIN_HOME/rpi-rgb-led-matrix/examples-api-use/"
        log "\n▶️ Running RGB Matrix demo..."
        sudo ./demo -D 1 runtext.ppm --led-rows=32 --led-cols=64 --led-limit-refresh=60 --led-slowdown-gpio=2 &
        sleep 10
        sudo pkill -SIGINT -f "demo"
        sleep 2
    fi
}
