#!/usr/bin/env bash

clone_plane_tracker() {
    if [ ! -d "$ADMIN_HOME/plane-tracker-rgb-pi" ]; then
        log "\n📂 Cloning plane-tracker-rgb-pi..."
        git clone https://github.com/chrismorgans/plane-tracker-rgb-pi.git "$ADMIN_HOME/plane-tracker-rgb-pi"
    else
        log "🔄 plane-tracker-rgb-pi already cloned."
    fi
}

prepare_core_dirs() {
    log "\n📁 Creating Core folders..."
    mkdir -p "$ADMIN_HOME/Core" "$ADMIN_HOME/Core-Backup"
    sudo chown -R admin:admin "$ADMIN_HOME/Core" "$ADMIN_HOME/Core-Backup" "$ADMIN_HOME/plane-tracker-rgb-pi"
    sudo chmod -R u+rwX "$ADMIN_HOME/Core" "$ADMIN_HOME/Core-Backup" "$ADMIN_HOME/plane-tracker-rgb-pi"
}

# ------------------------------------------------------------
# New addition: safely move rgbmatrix folder to its-a-plane-python
# Mirrors: sudo mv /home/admin/rpi-rgb-led-matrix/bindings/python/rgbmatrix /home/admin/plane-tracker-rgb-pi/its-a-plane-python/
# Paths use $ADMIN_HOME to match the rest of the script.
# ------------------------------------------------------------
move_rgbmatrix() {
    local SRC="$ADMIN_HOME/rpi-rgb-led-matrix/bindings/python/rgbmatrix"
    local DEST="$ADMIN_HOME/plane-tracker-rgb-pi/its-a-plane-python/"

    log "\n🚚 Moving rgbmatrix from '$SRC' to '$DEST'..."

    if [ ! -d "$SRC" ]; then
        log "❌ Source not found or not a directory: $SRC"
        return 1
    fi

    # Ensure destination directory exists
    if [ ! -d "$DEST" ]; then
        log "📁 Destination directory missing. Creating: $DEST"
        sudo mkdir -p "$DEST" || { log "❌ Failed to create destination: $DEST"; return 1; }
    fi

    # Perform move
    if sudo mv -- "$SRC" "$DEST"; then
        log "✅ Move complete: '$DEST'"
        return 0
    else
        log "❌ Move failed."
        return 1
    fi
}
