#!/usr/bin/env bash

set -euo pipefail

INSTALL_DIR="$(dirname "$0")"
source "$INSTALL_DIR/utils.sh"
source "$INSTALL_DIR/system.sh"
source "$INSTALL_DIR/internet.sh"
source "$INSTALL_DIR/rgb_matrix.sh"
source "$INSTALL_DIR/wifi_connect.sh"
source "$INSTALL_DIR/libraries.sh"
source "$INSTALL_DIR/plane_tracker.sh"
source "$INSTALL_DIR/scripts_deploy.sh"
source "$INSTALL_DIR/cleanup.sh"

main() {
    log "\n🚀 Starting smart installer..."
    run_safely update_system
    run_safely check_internet
    run_safely install_rgb_matrix
    run_safely run_demo
    run_safely setup_wifi_connect
    run_safely install_libraries
    run_safely upgrade_pip_if_needed
    run_safely upgrade_pillow
    run_safely install_flightradar24_api
    run_safely install_pytz_tqdm
    run_safely clone_plane_tracker
    run_safely prepare_core_dirs
    run_safely deploy_scripts
    run_safely setup_systemd_service
    run_safely disable_bluetooth
    run_safely configure_cpu_isolation
    run_safely cleanup_folders
    log "\n✅ Smart installation complete!"
}

main
