#!/usr/bin/env bash

install_libraries() {
    log "\n📚 Installing general-purpose libraries..."
    sudo apt-get update
    sudo apt-get install -y libjpeg-dev zlib1g-dev libfreetype6-dev liblcms2-dev \
                         libopenjpeg-dev libtiff5-dev tk-dev tcl-dev \
                         libwebp-dev libharfbuzz-dev libfribidi-dev libxcb1-dev
}

upgrade_pip_if_needed() {
    log "\n⬆️  Checking and upgrading pip if needed..."
    CURRENT_PIP_VER=$(pip3 --version | awk '{print $2}')
    sudo python3 -m pip install --upgrade pip
    NEW_PIP_VER=$(pip3 --version | awk '{print $2}')
    if [ "$CURRENT_PIP_VER" != "$NEW_PIP_VER" ]; then
        log "⬆️  pip upgraded: $CURRENT_PIP_VER → $NEW_PIP_VER"
    else
        log "🔄 pip is already up-to-date ($CURRENT_PIP_VER)."
    fi
}

upgrade_pillow() {
    log "\n🖼️  Checking and upgrading Pillow..."
    CURRENT_PIL_VER=$(pip3 show Pillow 2>/dev/null | awk '/Version/ {print $2}')
    sudo pip3 install --upgrade Pillow
    NEW_PIL_VER=$(pip3 show Pillow | awk '/Version/ {print $2}')
    log "✅ Pillow upgraded (or installed): ${CURRENT_PIL_VER:-not installed} → $NEW_PIL_VER"
}

install_flightradar24_api() {
    log "\n🙱 Installing FlightRadar24 API..."
    sudo pip3 install --no-cache-dir FlightRadarAPI
}

install_pytz_tqdm() {
    log "\n📦 Installing Python packages: pytz and tqdm..."
    sudo pip3 install --no-cache-dir pytz tqdm
}
