#!/usr/bin/env bash

disable_bluetooth() {
    log "\n📴 Disabling Bluetooth..."
    sudo rfkill block bluetooth
}

cleanup_folders() {
    log "\n🧹 Cleaning up user folders..."
    for dir in Bookshelf Music Pictures Videos Documents Public Downloads; do
        local target="$ADMIN_HOME/$dir"
        if [ -d "$target" ]; then
            log "🗑️  Deleting $target"
            sudo rm -rf "$target"
        else
            log "✔️  $target does not exist, skipping."
        fi
    done
}
