# run_all.py

import subprocess
import sys
import os
import time
from datetime import datetime
import shutil

SCRIPTS = [
    "/home/admin/start_wifi.py",
    "/home/admin/download.py",
    "/home/admin/plane-tracker-rgb-pi/its-a-plane-python/its-a-plane.py"
]

LOG_FILE = "/home/admin/run_all_log.txt"
MAX_LOG_SIZE = 5 * 1024 * 1024  # 5 MB


def rotate_log():
    if os.path.isfile(LOG_FILE) and os.path.getsize(LOG_FILE) > MAX_LOG_SIZE:
        timestamp = datetime.now().strftime("%Y%m%d_%H%M%S")
        archived_log = f"{LOG_FILE}.{timestamp}.bak"
        shutil.move(LOG_FILE, archived_log)


def log(message: str, level: str = "INFO") -> None:
    rotate_log()
    timestamp = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    formatted_message = f"[{timestamp}] [{level}] {message}\n"

    if level == "ERROR":
        sys.stderr.write(formatted_message)
    else:
        sys.stdout.write(formatted_message)

    with open(LOG_FILE, "a") as f:
        f.write(formatted_message)


def run_script(path: str) -> None:
    start_time = datetime.now()
    log(f"Initiating script: {path} at {start_time.strftime('%Y-%m-%d %H:%M:%S')}")

    if not os.path.isfile(path):
        log(f"Script file not found: {path}", level="ERROR")
        return

    try:
        result = subprocess.run(["python3", path], check=True, capture_output=True, text=True)
        end_time = datetime.now()
        duration = (end_time - start_time).total_seconds()
        log(f"Script completed: {path}\nStart Time: {start_time.strftime('%Y-%m-%d %H:%M:%S')}\nEnd Time: {end_time.strftime('%Y-%m-%d %H:%M:%S')}\nDuration: {duration:.2f} seconds\nExit Code: {result.returncode}\nStdout:\n{result.stdout.strip()}\nStderr:\n{result.stderr.strip() if result.stderr else 'None'}")
    except subprocess.CalledProcessError as e:
        end_time = datetime.now()
        duration = (end_time - start_time).total_seconds()
        log(f"Script failed: {path}\nStart Time: {start_time.strftime('%Y-%m-%d %H:%M:%S')}\nEnd Time: {end_time.strftime('%Y-%m-%d %H:%M:%S')}\nDuration: {duration:.2f} seconds\nExit Code: {e.returncode}\nOutput:\n{e.output if e.output else 'None'}\nError Output:\n{e.stderr if e.stderr else 'None'}", level="ERROR")


def main() -> None:
    log("== Starting Script Sequence ==")
    run_script(SCRIPTS[0])
    run_script(SCRIPTS[1])
    log(f"Delaying 2.5 seconds before next script...")
    time.sleep(2.5)
    run_script(SCRIPTS[2])
    log("== Script Sequence Complete ==")


if __name__ == "__main__":
    main()
