import time
import subprocess
import os

from rgbmatrix import RGBMatrix, RGBMatrixOptions, graphics

# Configuration for the matrix panel
options = RGBMatrixOptions()
options.rows = 32
options.cols = 64
options.chain_length = 1
options.parallel = 1
options.hardware_mapping = 'adafruit-hat'

# Set initial brightness
options.brightness = 75
options.gpio_slowdown = 2

matrix = RGBMatrix(options=options)
canvas = matrix.CreateFrameCanvas()

# Font settings (5x7)
font = graphics.Font()
font.LoadFont("/home/admin/rpi-rgb-led-matrix/fonts/5x7.bdf")
text_white = graphics.Color(255, 255, 255)
text_red = graphics.Color(255, 0, 0)
text_green = graphics.Color(0, 255, 0)

# Function to display text on the matrix
def display_text(lines, colors, duration=None):
    """ Displays text on the RGB matrix panel, centered """
    canvas.Clear()
    panel_width = options.cols
    panel_height = options.rows
    line_height = font.height
    total_text_height = len(lines) * line_height
    start_y = (panel_height - total_text_height) // 2 + line_height

    for i, line in enumerate(lines):
        text_length = graphics.DrawText(canvas, font, 0, 0, colors[i], line)
        x_pos = (panel_width - text_length) // 2
        y_pos = start_y + (i * line_height)
        graphics.DrawText(canvas, font, x_pos, y_pos, colors[i], line)

    matrix.SwapOnVSync(canvas)
    if duration:
        time.sleep(duration)
        canvas.Clear()
        matrix.SwapOnVSync(canvas)

# Function to check WiFi connection
def check_wifi():
    """ Check if the device is connected to WiFi by pinging Google """
    try:
        subprocess.run(["ping", "-c", "1", "8.8.8.8"], stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL, check=True)
        return True
    except subprocess.CalledProcessError:
        return False

# Function to get IP address
def get_ip_address():
    """ Retrieve the IP address of the device """
    try:
        ip_address = subprocess.check_output("hostname -I", shell=True).decode().strip().split()[0]
    except Exception:
        ip_address = "Unknown"
    return ip_address

# Display welcome message
display_text(["PLANES", "IN THE", "CLOUDS.COM"], [text_white] * 3, duration=10)

# Check WiFi before displaying anything
if not check_wifi():
    display_text(["CONFIGURE", "WIFI"], [text_red, text_red])
    while not check_wifi():
        time.sleep(5)

# Once WiFi is connected, update the display
ip_address = get_ip_address()
display_text(["WIFI", "CONNECTED", ip_address], [text_green, text_green, text_white], duration=10)

# Display "LOADING" for 10 seconds
# display_text(["LOADING"], [text_white], duration=10)

# import subprocess
# subprocess.run(["python3", "/home/admin/delete.py"])
