from PIL import Image, ImageDraw, ImageFont
import os

from utilities.animator import Animator
from setup import colours

LOGO_SIZE = 16
DEFAULT_IMAGE = "default"

# Pillow version compatibility: use Resampling.LANCZOS or fallback to LANCZOS
try:
    RESAMPLING = Image.Resampling.LANCZOS
except AttributeError:
    RESAMPLING = Image.LANCZOS

# Dynamically resolve project root and correct logos directory
BASE_DIR = os.path.abspath(os.path.join(os.path.dirname(__file__), ".."))
LOGO_DIR = os.path.join(BASE_DIR, "logos")
DEFAULT_PATH = os.path.join(LOGO_DIR, f"{DEFAULT_IMAGE}.png")

class FlightLogoScene:
    @Animator.KeyFrame.add(0)
    def logo_details(self, frame):
        if len(self._data) == 0:
            return False

        self.draw_square(
            0,
            0,
            LOGO_SIZE,
            LOGO_SIZE,
            colours.BLACK,
        )

        icao = self._data[self._data_index]["owner_icao"]
        if icao in ("", "N/A"):
            icao = DEFAULT_IMAGE

        logo_path = os.path.join(LOGO_DIR, f"{icao}.png")

        if not os.path.isfile(logo_path):
            print(f"Logo for '{icao}' not found. Falling back to default.")
            if not os.path.isfile(DEFAULT_PATH):
                print("Default logo missing — generating one.")
                self._create_default_logo(DEFAULT_PATH)
            logo_path = DEFAULT_PATH

        image = Image.open(logo_path)
        image.thumbnail((LOGO_SIZE, LOGO_SIZE), RESAMPLING)
        self.matrix.SetImage(image.convert('RGB'))

        return False

    def _create_default_logo(self, path):
        os.makedirs(os.path.dirname(path), exist_ok=True)
        image = Image.new("RGB", (LOGO_SIZE, LOGO_SIZE), "black")
        draw = ImageDraw.Draw(image)
        font = ImageFont.load_default()
        draw.text((2, 4), "N/A", fill="white", font=font)
        image.save(path)
